/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Graphics;
import java.util.StringTokenizer;

class WireElm
extends CircuitElm {
    static final int FLAG_SHOWCURRENT = 1;
    static final int FLAG_SHOWVOLTAGE = 2;

    public WireElm(int n, int n2) {
        super(n, n2);
    }

    public WireElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
    }

    void draw(Graphics graphics) {
        this.setVoltageColor(graphics, this.volts[0]);
        WireElm.drawThickLine(graphics, this.point1, this.point2);
        this.doDots(graphics);
        this.setBbox(this.point1, this.point2, 3.0);
        if (this.mustShowCurrent()) {
            String string = WireElm.getShortUnitText(Math.abs(this.getCurrent()), "A");
            this.drawValues(graphics, string, 4.0);
        } else if (this.mustShowVoltage()) {
            String string = WireElm.getShortUnitText(this.volts[0], "V");
            this.drawValues(graphics, string, 4.0);
        }
        this.drawPosts(graphics);
    }

    void stamp() {
        sim.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, 0.0);
    }

    boolean mustShowCurrent() {
        return (this.flags & 1) != 0;
    }

    boolean mustShowVoltage() {
        return (this.flags & 2) != 0;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "wire";
        stringArray[1] = "I = " + WireElm.getCurrentDText(this.getCurrent());
        stringArray[2] = "V = " + WireElm.getVoltageText(this.volts[0]);
    }

    int getDumpType() {
        return 119;
    }

    double getPower() {
        return 0.0;
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    boolean isWire() {
        return true;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Show Current", this.mustShowCurrent());
            return editInfo;
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Show Voltage", this.mustShowVoltage());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.flags = editInfo.checkbox.getState() ? 1 : (this.flags &= 0xFFFFFFFE);
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? 2 : (this.flags &= 0xFFFFFFFD);
        }
    }

    int getShortcut() {
        return 119;
    }
}

