/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class TunnelDiodeElm
extends CircuitElm {
    final int hs = 8;
    Polygon poly;
    Point[] cathode;
    double lastvoltdiff;
    static final double pvp = 0.1;
    static final double pip = 0.0047;
    static final double pvv = 0.37;
    static final double pvt = 0.026;
    static final double pvpp = 0.525;
    static final double piv = 3.7E-4;

    public TunnelDiodeElm(int n, int n2) {
        super(n, n2);
        this.setup();
    }

    public TunnelDiodeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.setup();
    }

    boolean nonLinear() {
        return true;
    }

    void setup() {
    }

    int getDumpType() {
        return 175;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(16);
        this.cathode = this.newPointArray(4);
        Point[] pointArray = this.newPointArray(2);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, 8.0);
        this.interpPoint2(this.lead1, this.lead2, this.cathode[0], this.cathode[1], 1.0, 8.0);
        this.interpPoint2(this.lead1, this.lead2, this.cathode[2], this.cathode[3], 0.8, 8.0);
        this.poly = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 8.0);
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, d);
        graphics.fillPolygon(this.poly);
        this.setVoltageColor(graphics, d2);
        TunnelDiodeElm.drawThickLine(graphics, this.cathode[0], this.cathode[1]);
        TunnelDiodeElm.drawThickLine(graphics, this.cathode[2], this.cathode[0]);
        TunnelDiodeElm.drawThickLine(graphics, this.cathode[3], this.cathode[1]);
        this.doDots(graphics);
        this.drawPosts(graphics);
    }

    void reset() {
        this.curcount = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.lastvoltdiff = 0.0;
    }

    double limitStep(double d, double d2) {
        if (d > d2 + 1.0) {
            return d2 + 1.0;
        }
        if (d < d2 - 1.0) {
            return d2 - 1.0;
        }
        return d;
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
    }

    void doStep() {
        double d = this.volts[0] - this.volts[1];
        if (Math.abs(d - this.lastvoltdiff) > 0.01) {
            TunnelDiodeElm.sim.converged = false;
        }
        this.lastvoltdiff = d = this.limitStep(d, this.lastvoltdiff);
        double d2 = 0.0047 * Math.exp(-20.192307692307693) * (Math.exp(d / 0.026) - 1.0) + 0.0047 * (d / 0.1) * Math.exp(1.0 - d / 0.1) + 3.7E-4 * Math.exp(d - 0.37);
        double d3 = 0.0047 * Math.exp(-20.192307692307693) * Math.exp(d / 0.026) / 0.026 + 0.0047 * Math.exp(1.0 - d / 0.1) / 0.1 - Math.exp(1.0 - d / 0.1) * 0.0047 * d / 0.010000000000000002 + Math.exp(d - 0.37) * 3.7E-4;
        double d4 = d2 - d3 * d;
        sim.stampConductance(this.nodes[0], this.nodes[1], d3);
        sim.stampCurrentSource(this.nodes[0], this.nodes[1], d4);
    }

    void calculateCurrent() {
        double d = this.volts[0] - this.volts[1];
        this.current = 0.0047 * Math.exp(-20.192307692307693) * (Math.exp(d / 0.026) - 1.0) + 0.0047 * (d / 0.1) * Math.exp(1.0 - d / 0.1) + 3.7E-4 * Math.exp(d - 0.37);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "tunnel diode";
        stringArray[1] = "I = " + TunnelDiodeElm.getCurrentText(this.getCurrent());
        stringArray[2] = "Vd = " + TunnelDiodeElm.getVoltageText(this.getVoltageDiff());
        stringArray[3] = "P = " + TunnelDiodeElm.getUnitText(this.getPower(), "W");
    }
}

